% mmconj.tex -- table of conjuncts
% Copyright 1993, 1994, 1995 Jeroen Hellingman
%
% History:
%   04-MAY-1998 updated transcription (JH)
%   23-NOV-1995 updated for new transcription scheme (JH)
%   29-MAR-1994 last edit (JH)

\nopagenumbers
\input mmmacs
\twelvemmr

\beginsection Consonant-Vowel combinations

\halign{\hfil#\ \hfil&&\hfil#\ \hfil\cr
$+$   & $a$   & $aa$   & $i$   & $ii$   & $u$    & $uu$  & $R$   & $RR$   & $L$   & $LL$   & $e$   & $ee$   & $ai$   & $o$   & $oo$   & $au$   & $a.m$   & $a.h$   \cr
%
$k$   & $ka$  & $kaa$  & $ki$  & $kii$  & $ku$   & $kuu$  & $kR$  & $kRR$  & $kL$  & $kLL$  & $ke$  & $kee$  & $kai$  & $ko$  & $koo$  & $kau$  & $ka.m$  & $ka.h$  \cr
$kh$  & $kha$ & $khaa$ & $khi$ & $khii$ & $khu$  & $khuu$ & $khR$ & $khRR$ & $khL$ & $khLL$ & $khe$ & $khee$ & $khai$ & $kho$ & $khoo$ & $khau$ & $kha.m$ & $kha.h$ \cr
$g$   & $ga$  & $gaa$  & $gi$  & $gii$  & $gu$   & $guu$  & $gR$  & $gRR$  & $gL$  & $gLL$  & $ge$  & $gee$  & $gai$  & $go$  & $goo$  & $gau$  & $ga.m$  & $ga.h$  \cr
$gh$  & $gha$ & $ghaa$ & $ghi$ & $ghii$ & $ghu$  & $ghuu$ & $ghR$ & $ghRR$ & $ghL$ & $ghLL$ & $ghe$ & $ghee$ & $ghai$ & $gho$ & $ghoo$ & $ghau$ & $gha.m$ & $gha.h$ \cr
$"n$  & $"na$ & $"naa$ & $"ni$ & $"nii$ & $"nu$  & $"nuu$ & $"nR$ & $"nRR$ & $"nL$ & $"nLL$ & $"ne$ & $"nee$ & $"nai$ & $"no$ & $"noo$ & $"nau$ & $"na.m$ & $"na.h$ \cr
%
$c$   & $ca$  & $caa$  & $ci$  & $cii$  & $cu$   & $cuu$  & $cR$  & $cRR$  & $cL$  & $cLL$  & $ce$  & $cee$  & $cai$  & $co$  & $coo$  & $cau$  & $ca.m$  & $ca.h$  \cr
$ch$  & $cha$ & $chaa$ & $chi$ & $chii$ & $chu$  & $chuu$ & $chR$ & $chRR$ & $chL$ & $chLL$ & $che$ & $chee$ & $chai$ & $cho$ & $choo$ & $chau$ & $cha.m$ & $cha.h$ \cr
$j$   & $ja$  & $jaa$  & $ji$  & $jii$  & $ju$   & $juu$  & $jR$  & $jRR$  & $jL$  & $jLL$  & $je$  & $jee$  & $jai$  & $jo$  & $joo$  & $jau$  & $ja.m$  & $ja.h$  \cr
$jh$  & $jha$ & $jhaa$ & $jhi$ & $jhii$ & $jhu$  & $jhuu$ & $jhR$ & $jhRR$ & $jhL$ & $jhLL$ & $jhe$ & $jhee$ & $jhai$ & $jho$ & $jhoo$ & $jhau$ & $jha.m$ & $jha.h$ \cr
$~n$  & $~na$ & $~naa$ & $~ni$ & $~nii$ & $~nu$  & $~nuu$ & $~nR$ & $~nRR$ & $~nL$ & $~nLL$ & $~ne$ & $~nee$ & $~nai$ & $~no$ & $~noo$ & $~nau$ & $~na.m$ & $~na.h$ \cr
%
$.t$   & $.ta$  & $.taa$  & $.ti$  & $.tii$  & $.tu$   & $.tuu$  & $.tR$  & $.tRR$  & $.tL$  & $.tLL$  & $.te$  & $.tee$  & $.tai$  & $.to$  & $.too$  & $.tau$  & $.ta.m$  & $.ta.h$  \cr
$.th$  & $.tha$ & $.thaa$ & $.thi$ & $.thii$ & $.thu$  & $.thuu$ & $.thR$ & $.thRR$ & $.thL$ & $.thLL$ & $.the$ & $.thee$ & $.thai$ & $.tho$ & $.thoo$ & $.thau$ & $.tha.m$ & $.tha.h$ \cr
$.d$   & $.da$  & $.daa$  & $.di$  & $.dii$  & $.du$   & $.duu$  & $.dR$  & $.dRR$  & $.dL$  & $.dLL$  & $.de$  & $.dee$  & $.dai$  & $.do$  & $.doo$  & $.dau$  & $.da.m$  & $.da.h$  \cr
$.dh$  & $.dha$ & $.dhaa$ & $.dhi$ & $.dhii$ & $.dhu$  & $.dhuu$ & $.dhR$ & $.dhRR$ & $.dhL$ & $.dhLL$ & $.dhe$ & $.dhee$ & $.dhai$ & $.dho$ & $.dhoo$ & $.dhau$ & $.dha.m$ & $.dha.h$ \cr
$.n$   & $.na$  & $.naa$  & $.ni$  & $.nii$  & $.nu$   & $.nuu$  & $.nR$  & $.nRR$  & $.nL$  & $.nLL$  & $.ne$  & $.nee$  & $.nai$  & $.no$  & $.noo$  & $.nau$  & $.na.m$  & $.na.h$  \cr
%
$t$   & $ta$  & $taa$  & $ti$  & $tii$  & $tu$   & $tuu$  & $tR$  & $tRR$  & $tL$  & $tLL$  & $te$  & $tee$  & $tai$  & $to$  & $too$  & $tau$  & $ta.m$  & $ta.h$  \cr
$th$  & $tha$ & $thaa$ & $thi$ & $thii$ & $thu$  & $thuu$ & $thR$ & $thRR$ & $thL$ & $thLL$ & $the$ & $thee$ & $thai$ & $tho$ & $thoo$ & $thau$ & $tha.m$ & $tha.h$ \cr
$d$   & $da$  & $daa$  & $di$  & $dii$  & $du$   & $duu$  & $dR$  & $dRR$  & $dL$  & $dLL$  & $de$  & $dee$  & $dai$  & $do$  & $doo$  & $dau$  & $da.m$  & $da.h$  \cr
$dh$  & $dha$ & $dhaa$ & $dhi$ & $dhii$ & $dhu$  & $dhuu$ & $dhR$ & $dhRR$ & $dhL$ & $dhLL$ & $dhe$ & $dhee$ & $dhai$ & $dho$ & $dhoo$ & $dhau$ & $dha.m$ & $dha.h$ \cr
$n$   & $na$  & $naa$  & $ni$  & $nii$  & $nu$   & $nuu$  & $nR$  & $nRR$  & $nL$  & $nLL$  & $ne$  & $nee$  & $nai$  & $no$  & $noo$  & $nau$  & $na.m$  & $na.h$  \cr
%
$p$   & $pa$  & $paa$  & $pi$  & $pii$  & $pu$   & $puu$  & $pR$  & $pRR$  & $pL$  & $pLL$  & $pe$  & $pee$  & $pai$  & $po$  & $poo$  & $pau$  & $pa.m$  & $pa.h$  \cr
$ph$  & $pha$ & $phaa$ & $phi$ & $phii$ & $phu$  & $phuu$ & $phR$ & $phRR$ & $phL$ & $phLL$ & $phe$ & $phee$ & $phai$ & $pho$ & $phoo$ & $phau$ & $pha.m$ & $pha.h$ \cr
$b$   & $ba$  & $baa$  & $bi$  & $bii$  & $bu$   & $buu$  & $bR$  & $bRR$  & $bL$  & $bLL$  & $be$  & $bee$  & $bai$  & $bo$  & $boo$  & $bau$  & $ba.m$  & $ba.h$  \cr
$bh$  & $bha$ & $bhaa$ & $bhi$ & $bhii$ & $bhu$  & $bhuu$ & $bhR$ & $bhRR$ & $bhL$ & $bhLL$ & $bhe$ & $bhee$ & $bhai$ & $bho$ & $bhoo$ & $bhau$ & $bha.m$ & $bha.h$ \cr
$m$   & $ma$  & $maa$  & $mi$  & $mii$  & $mu$   & $muu$  & $mR$  & $mRR$  & $mL$  & $mLL$  & $me$  & $mee$  & $mai$  & $mo$  & $moo$  & $mau$  & $ma.m$  & $ma.h$  \cr
%
$y$   & $ya$  & $yaa$  & $yi$  & $yii$  & $yu$   & $yuu$  & $yR$  & $yRR$  & $yL$  & $yLL$  & $ye$  & $yee$  & $yai$  & $yo$  & $yoo$  & $yau$  & $ya.m$  & $ya.h$  \cr
$r$   & $ra$  & $raa$  & $ri$  & $rii$  & $ru$   & $ruu$  & $rR$  & $rRR$  & $rL$  & $rLL$  & $re$  & $ree$  & $rai$  & $ro$  & $roo$  & $rau$  & $ra.m$  & $ra.h$  \cr
$.r$   & $.ra$  & $.raa$  & $.ri$  & $.rii$  & $.ru$   & $.ruu$  & $.rR$  & $.rRR$  & $.rL$  & $.rLL$  & $.re$  & $.ree$  & $.rai$  & $.ro$  & $.roo$  & $.rau$  & $.ra.m$  & $.ra.h$  \cr
$l$   & $la$  & $laa$  & $li$  & $lii$  & $lu$   & $luu$  & $lR$  & $lRR$  & $lL$  & $lLL$  & $le$  & $lee$  & $lai$  & $lo$  & $loo$  & $lau$  & $la.m$  & $la.h$  \cr
$v$   & $va$  & $vaa$  & $vi$  & $vii$  & $vu$   & $vuu$  & $vR$  & $vRR$  & $vL$  & $vLL$  & $ve$  & $vee$  & $vai$  & $vo$  & $voo$  & $vau$  & $va.m$  & $va.h$  \cr
$sh$  & $sha$ & $shaa$ & $shi$ & $shii$ & $shu$  & $shuu$ & $shR$ & $shRR$ & $shL$ & $shLL$ & $she$ & $shee$ & $shai$ & $sho$ & $shoo$ & $shau$ & $sha.m$ & $sha.h$ \cr
$.s$   & $.sa$  & $.saa$  & $.si$  & $.sii$  & $.su$   & $.suu$  & $.sR$  & $.sRR$  & $.sL$  & $.sLL$  & $.se$  & $.see$  & $.sai$  & $.so$  & $.soo$  & $.sau$  & $.sa.m$  & $.sa.h$  \cr
$s$   & $sa$  & $saa$  & $si$  & $sii$  & $su$   & $suu$  & $sR$  & $sRR$  & $sL$  & $sLL$  & $se$  & $see$  & $sai$  & $so$  & $soo$  & $sau$  & $sa.m$  & $sa.h$  \cr
$h$   & $ha$  & $haa$  & $hi$  & $hii$  & $hu$   & $huu$  & $hR$  & $hRR$  & $hL$  & $hLL$  & $he$  & $hee$  & $hai$  & $ho$  & $hoo$  & $hau$  & $ha.m$  & $ha.h$  \cr
$.l$   & $.la$  & $.laa$  & $.li$  & $.lii$  & $.lu$   & $.luu$  & $.lR$  & $.lRR$  & $.lL$  & $.lLL$  & $.le$  & $.lee$  & $.lai$  & $.lo$  & $.loo$  & $.lau$  & $.la.m$  & $.la.h$  \cr
$zh$  & $zha$ & $zhaa$ & $zhi$ & $zhii$ & $zhu$  & $zhuu$ & $zhR$ & $zhRR$ & $zhL$ & $zhLL$ & $zhe$ & $zhee$ & $zhai$ & $zho$ & $zhoo$ & $zhau$ & $zha.m$ & $zha.h$ \cr
}

\beginsection Consonant-Consonant combinations

\beginsection {\twelvemmb $ka$}

$ kka,  kkha,  kga,  kgha,  k"na,
  kca,  kcha,  kja,  kjha,  k~na,
  k.ta,  k.tha,  k.da,  k.dha,  k.na,
  kta,  ktha,  kda,  kdha,  kna,
  kpa,  kpha,  kba,  kbha,  kma,
  kya,  kra,   k.ra,  kla,   kva,
  ksha, k.sa,   ksa,  k>ha,  k.la,  kzha.$

\beginsection {\twelvemmb $kha$}

$ khka,  khkha,  khga,  khgha,  kh"na,
  khca,  khcha,  khja,  khjha,  kh~na,
  kh.ta,  kh.tha,  kh.da,  kh.dha,  kh.na,
  khta,  khtha,  khda,  khdha,  khna,
  khpa,  khpha,  khba,  khbha,  khma,
  khya,  khra,   kh.ra,  khla,   khva,
  khsha, kh.sa,   khsa,  khha,   kh.la,  khzha.$

\beginsection {\twelvemmb $ga$}

$ gka,  gkha,  gga,  ggha,  g"na,
  gca,  gcha,  gja,  gjha,  g~na,
  g.ta,  g.tha,  g.da,  g.dha,  g.na,
  gta,  gtha,  gda,  gdha,  gna,
  gpa,  gpha,  gba,  gbha,  gma,
  gya,  gra,   g.ra,  gla,   gva,
  gsha, g.sa,   gsa,  g>ha,  g.la,  gzha.$

\beginsection {\twelvemmb $gha$}

$ ghka,  ghkha,  ghga,  ghgha,  gh"na,
  ghca,  ghcha,  ghja,  ghjha,  gh~na,
  gh.ta,  gh.tha,  gh.da,  gh.dha,  gh.na,
  ghta,  ghtha,  ghda,  ghdha,  ghna,
  ghpa,  ghpha,  ghba,  ghbha,  ghma,
  ghya,  ghra,   gh.ra,  ghla,   ghva,
  ghsha, gh.sa,   ghsa,  ghha,   gh.la,  ghzha.$

\beginsection {\twelvemmb $"na$}

$ "nka,  "nkha,  "nga,  "ngha,  "n"na,
  "nca,  "ncha,  "nja,  "njha,  "n~na,
  "n.ta,  "n.tha,  "n.da,  "n.dha,  "n.na,
  "nta,  "ntha,  "nda,  "ndha,  "nna,
  "npa,  "npha,  "nba,  "nbha,  "nma,
  "nya,  "nra,   "n.ra,  "nla,   "nva,
  "nsha, "n.sa,   "nsa,  "nha,   "n.la,  "nzha.$

\beginsection {\twelvemmb $ca$}

$ cka,  ckha,  cga,  cgha,  c"na,
  cca,  ccha,  cja,  cjha,  c~na,
  c.ta,  c.tha,  c.da,  c.dha,  c.na,
  cta,  ctha,  cda,  cdha,  cna,
  cpa,  cpha,  cba,  cbha,  cma,
  cya,  cra,   c.ra,  cla,   cva,
  csha, c.sa,   csa,  c>ha,  c.la,  czha.$

\beginsection {\twelvemmb $cha$}

$ chka,  chkha,  chga,  chgha,  ch"na,
  chca,  chcha,  chja,  chjha,  ch~na,
  ch.ta,  ch.tha,  ch.da,  ch.dha,  ch.na,
  chta,  chtha,  chda,  chdha,  chna,
  chpa,  chpha,  chba,  chbha,  chma,
  chya,  chra,   ch.ra,  chla,   chva,
  chsha, ch.sa,   chsa,  chha,   ch.la,  chzha.$

\beginsection {\twelvemmb $ja$}

$ jka,  jkha,  jga,  jgha,  j"na,
  jca,  jcha,  jja,  jjha,  j~na,
  j.ta,  j.tha,  j.da,  j.dha,  j.na,
  jta,  jtha,  jda,  jdha,  jna,
  jpa,  jpha,  jba,  jbha,  jma,
  jya,  jra,   j.ra,  jla,   jva,
  jsha, j.sa,   jsa,  j>ha,  j.la,  jzha.$

\beginsection {\twelvemmb $jha$}

$ jhka,  jhkha,  jhga,  jhgha,  jh"na,
  jhca,  jhcha,  jhja,  jhjha,  jh~na,
  jh.ta,  jh.tha,  jh.da,  jh.dha,  jh.na,
  jhta,  jhtha,  jhda,  jhdha,  jhna,
  jhpa,  jhpha,  jhba,  jhbha,  jhma,
  jhya,  jhra,   jh.ra,  jhla,   jhva,
  jhsha, jh.sa,   jhsa,  jhha,   jh.la,  jhzha.$

\beginsection {\twelvemmb $~na$}

$ ~nka,  ~nkha,  ~nga,  ~ngha,  ~n"na,
  ~nca,  ~ncha,  ~nja,  ~njha,  ~n~na,
  ~n.ta,  ~n.tha,  ~n.da,  ~n.dha,  ~n.na,
  ~nta,  ~ntha,  ~nda,  ~ndha,  ~nna,
  ~npa,  ~npha,  ~nba,  ~nbha,  ~nma,
  ~nya,  ~nra,   ~n.ra,  ~nla,   ~nva,
  ~nsha, ~n.sa,   ~nsa,  ~nha,   ~n.la,  ~nzha.$

\beginsection {\twelvemmb $.ta$}

$ .tka,  .tkha,  .tga,  .tgha,  .t"na,
  .tca,  .tcha,  .tja,  .tjha,  .t~na,
  .t.ta,  .t.tha,  .t.da,  .t.dha,  .t.na,
  .tta,  .ttha,  .tda,  .tdha,  .tna,
  .tpa,  .tpha,  .tba,  .tbha,  .tma,
  .tya,  .tra,   .t.ra,  .tla,   .tva,
  .tsha, .t.sa,   .tsa,  .t>ha,  .t.la,  .tzha.$

\beginsection {\twelvemmb $.tha$}

$ .thka,  .thkha,  .thga,  .thgha,  .th"na,
  .thca,  .thcha,  .thja,  .thjha,  .th~na,
  .th.ta,  .th.tha,  .th.da,  .th.dha,  .th.na,
  .thta,  .ththa,  .thda,  .thdha,  .thna,
  .thpa,  .thpha,  .thba,  .thbha,  .thma,
  .thya,  .thra,   .th.ra,  .thla,   .thva,
  .thsha, .th.sa,   .thsa,  .thha,   .th.la,  .thzha.$

\beginsection {\twelvemmb $.da$}

$ .dka,  .dkha,  .dga,  .dgha,  .d"na,
  .dca,  .dcha,  .dja,  .djha,  .d~na,
  .d.ta,  .d.tha,  .d.da,  .d.dha,  .d.na,
  .dta,  .dtha,  .dda,  .ddha,  .dna,
  .dpa,  .dpha,  .dba,  .dbha,  .dma,
  .dya,  .dra,   .d.ra,  .dla,   .dva,
  .dsha, .d.sa,   .dsa,  .d>ha,  .d.la,  .dzha.$

\beginsection {\twelvemmb $.dha$}

$ .dhka,  .dhkha,  .dhga,  .dhgha,  .dh"na,
  .dhca,  .dhcha,  .dhja,  .dhjha,  .dh~na,
  .dh.ta,  .dh.tha,  .dh.da,  .dh.dha,  .dh.na,
  .dhta,  .dhtha,  .dhda,  .dhdha,  .dhna,
  .dhpa,  .dhpha,  .dhba,  .dhbha,  .dhma,
  .dhya,  .dhra,   .dh.ra,  .dhla,   .dhva,
  .dhsha, .dh.sa,   .dhsa,  .dhha,   .dh.la,  .dhzha.$

\beginsection {\twelvemmb $.na$}

$ .nka,  .nkha,  .nga,  .ngha,  .n"na,
  .nca,  .ncha,  .nja,  .njha,  .n~na,
  .n.ta,  .n.tha,  .n.da,  .n.dha,  .n.na,
  .nta,  .ntha,  .nda,  .ndha,  .nna,
  .npa,  .npha,  .nba,  .nbha,  .nma,
  .nya,  .nra,   .n.ra,  .nla,   .nva,
  .nsha, .n.sa,   .nsa,  .nha,   .n.la,  .nzha.$

\beginsection {\twelvemmb $ta$}

$ tka,  tkha,  tga,  tgha,  t"na,
  tca,  tcha,  tja,  tjha,  t~na,
  t.ta,  t.tha,  t.da,  t.dha,  t.na,
  tta,  ttha,  tda,  tdha,  tna,
  tpa,  tpha,  tba,  tbha,  tma,
  tya,  tra,   t.ra,  tla,   tva,
  tsha, t.sa,   tsa,  t>ha,  t.la,  tzha.$

\beginsection {\twelvemmb $tha$}

$ thka,  thkha,  thga,  thgha,  th"na,
  thca,  thcha,  thja,  thjha,  th~na,
  th.ta,  th.tha,  th.da,  th.dha,  th.na,
  thta,  ththa,  thda,  thdha,  thna,
  thpa,  thpha,  thba,  thbha,  thma,
  thya,  thra,   th.ra,  thla,   thva,
  thsha, th.sa,   thsa,  thha,   th.la,  thzha.$

\beginsection {\twelvemmb $da$}

$ dka,  dkha,  dga,  dgha,  d"na,
  dca,  dcha,  dja,  djha,  d~na,
  d.ta,  d.tha,  d.da,  d.dha,  d.na,
  dta,  dtha,  dda,  ddha,  dna,
  dpa,  dpha,  dba,  dbha,  dma,
  dya,  dra,   d.ra,  dla,   dva,
  dsha, d.sa,   dsa,  d>ha,  d.la,  dzha.$

\beginsection {\twelvemmb $dha$}

$ dhka,  dhkha,  dhga,  dhgha,  dh"na,
  dhca,  dhcha,  dhja,  dhjha,  dh~na,
  dh.ta,  dh.tha,  dh.da,  dh.dha,  dh.na,
  dhta,  dhtha,  dhda,  dhdha,  dhna,
  dhpa,  dhpha,  dhba,  dhbha,  dhma,
  dhya,  dhra,   dh.ra,  dhla,   dhva,
  dhsha, dh.sa,   dhsa,  dhha,   dh.la,  dhzha.$

\beginsection {\twelvemmb $na$}

$ nka,  nkha,  nga,  ngha,  n"na,
  nca,  ncha,  nja,  njha,  n~na,
  n.ta,  n.tha,  n.da,  n.dha,  n.na,
  nta,  ntha,  nda,  ndha,  nna,
  npa,  npha,  nba,  nbha,  nma,
  nya,  nra,   n.ra,  nla,   nva,
  nsha, n.sa,   nsa,  nha,   n.la,  nzha.$

\beginsection {\twelvemmb $pa$}

$ pka,  pkha,  pga,  pgha,  p"na,
  pca,  pcha,  pja,  pjha,  p~na,
  p.ta,  p.tha,  p.da,  p.dha,  p.na,
  pta,  ptha,  pda,  pdha,  pna,
  ppa,  ppha,  pba,  pbha,  pma,
  pya,  pra,   p.ra,  pla,   pva,
  psha, p.sa,   psa,  p>ha,  p.la,  pzha.$

\beginsection {\twelvemmb $pha$}

$ phka,  phkha,  phga,  phgha,  ph"na,
  phca,  phcha,  phja,  phjha,  ph~na,
  ph.ta,  ph.tha,  ph.da,  ph.dha,  ph.na,
  phta,  phtha,  phda,  phdha,  phna,
  phpa,  phpha,  phba,  phbha,  phma,
  phya,  phra,   ph.ra,  phla,   phva,
  phsha, ph.sa,   phsa,  phha,   ph.la,  phzha.$

\beginsection {\twelvemmb $ba$}

$ bka,  bkha,  bga,  bgha,  b"na,
  bca,  bcha,  bja,  bjha,  b~na,
  b.ta,  b.tha,  b.da,  b.dha,  b.na,
  bta,  btha,  bda,  bdha,  bna,
  bpa,  bpha,  bba,  bbha,  bma,
  bya,  bra,   b.ra,  bla,   bva,
  bsha, b.sa,   bsa,  b>ha,  b.la,  bzha.$

\beginsection {\twelvemmb $bha$}

$ bhka,  bhkha,  bhga,  bhgha,  bh"na,
  bhca,  bhcha,  bhja,  bhjha,  bh~na,
  bh.ta,  bh.tha,  bh.da,  bh.dha,  bh.na,
  bhta,  bhtha,  bhda,  bhdha,  bhna,
  bhpa,  bhpha,  bhba,  bhbha,  bhma,
  bhya,  bhra,   bh.ra,  bhla,   bhva,
  bhsha, bh.sa,   bhsa,  bhha,   bh.la,  bhzha.$

\beginsection {\twelvemmb $ma$}

$ mka,  mkha,  mga,  mgha,  m"na,
  mca,  mcha,  mja,  mjha,  m~na,
  m.ta,  m.tha,  m.da,  m.dha,  m.na,
  mta,  mtha,  mda,  mdha,  mna,
  mpa,  mpha,  mba,  mbha,  mma,
  mya,  mra,   m.ra,  mla,   mva,
  msha, m.sa,   msa,  mha,   m.la,  mzha.$

\beginsection {\twelvemmb $ya$}

$ yka,  ykha,  yga,  ygha,  y"na,
  yca,  ycha,  yja,  yjha,  y~na,
  y.ta,  y.tha,  y.da,  y.dha,  y.na,
  yta,  ytha,  yda,  ydha,  yna,
  ypa,  ypha,  yba,  ybha,  yma,
  yya,  yra,   y.ra,  yla,   yva,
  ysha, y.sa,   ysa,  yha,   y.la,  yzha.$

\beginsection {\twelvemmb $ra$}

$ rka,  rkha,  rga,  rgha,  r"na,
  rca,  rcha,  rja,  rjha,  r~na,
  r.ta,  r.tha,  r.da,  r.dha,  r.na,
  rta,  rtha,  rda,  rdha,  rna,
  rpa,  rpha,  rba,  rbha,  rma,
  rya,  rra,   r.ra,  rla,   rva,
  rsha, r.sa,   rsa,  rha,   r.la,  rzha.$

\beginsection {\twelvemmb $.ra$}

$ .rka,  .rkha,  .rga,  .rgha,  .r"na,
  .rca,  .rcha,  .rja,  .rjha,  .r~na,
  .r.ta,  .r.tha,  .r.da,  .r.dha,  .r.na,
  .rta,  .rtha,  .rda,  .rdha,  .rna,
  .rpa,  .rpha,  .rba,  .rbha,  .rma,
  .rya,  .rra,   .r.ra,  .rla,   .rva,
  .rsha, .r.sa,   .rsa,  .rha,   .r.la,  .rzha.$

\beginsection {\twelvemmb $la$}

$ lka,  lkha,  lga,  lgha,  l"na,
  lca,  lcha,  lja,  ljha,  l~na,
  l.ta,  l.tha,  l.da,  l.dha,  l.na,
  lta,  ltha,  lda,  ldha,  lna,
  lpa,  lpha,  lba,  lbha,  lma,
  lya,  lra,   l.ra,  lla,   lva,
  lsha, l.sa,   lsa,  lha,   l.la,  lzha.$

\beginsection {\twelvemmb $va$}

$ vka,  vkha,  vga,  vgha,  v"na,
  vca,  vcha,  vja,  vjha,  v~na,
  v.ta,  v.tha,  v.da,  v.dha,  v.na,
  vta,  vtha,  vda,  vdha,  vna,
  vpa,  vpha,  vba,  vbha,  vma,
  vya,  vra,   v.ra,  vla,   vva,
  vsha, v.sa,   vsa,  vha,   v.la,  vzha.$

\beginsection {\twelvemmb $sha$}

$ shka,  shkha,  shga,  shgha,  sh"na,
  shca,  shcha,  shja,  shjha,  sh~na,
  sh.ta,  sh.tha,  sh.da,  sh.dha,  sh.na,
  shta,  shtha,  shda,  shdha,  shna,
  shpa,  shpha,  shba,  shbha,  shma,
  shya,  shra,   sh.ra,  shla,   shva,
  shsha, sh.sa,   shsa,  shha,   sh.la,  shzha.$

\beginsection {\twelvemmb $.sa$}

$ .ska,  .skha,  .sga,  .sgha,  .s"na,
  .sca,  .scha,  .sja,  .sjha,  .s~na,
  .s.ta,  .s.tha,  .s.da,  .s.dha,  .s.na,
  .sta,  .stha,  .sda,  .sdha,  .sna,
  .spa,  .spha,  .sba,  .sbha,  .sma,
  .sya,  .sra,   .s.ra,  .sla,   .sva,
  .ssha, .s.sa,   .ssa,  .sha,   .s.la,  .szha.$

\beginsection {\twelvemmb $sa$}

$ ska,  skha,  sga,  sgha,  s"na,
  sca,  scha,  sja,  sjha,  s~na,
  s.ta,  s.tha,  s.da,  s.dha,  s.na,
  sta,  stha,  sda,  sdha,  sna,
  spa,  spha,  sba,  sbha,  sma,
  sya,  sra,   s.ra,  sla,   sva,
  ssha, s.sa,   ssa,  s>ha,  s.la,  szha.$

\beginsection {\twelvemmb $ha$}

$ hka,  hkha,  hga,  hgha,  h"na,
  hca,  hcha,  hja,  hjha,  h~na,
  h.ta,  h.tha,  h.da,  h.dha,  h.na,
  hta,  htha,  hda,  hdha,  hna,
  hpa,  hpha,  hba,  hbha,  hma,
  hya,  hra,   h.ra,  hla,   hva,
  hsha, h.sa,   hsa,  hha,   h.la,  hzha.$

\beginsection {\twelvemmb $.la$}

$ .lka,  .lkha,  .lga,  .lgha,  .l"na,
  .lca,  .lcha,  .lja,  .ljha,  .l~na,
  .l.ta,  .l.tha,  .l.da,  .l.dha,  .l.na,
  .lta,  .ltha,  .lda,  .ldha,  .lna,
  .lpa,  .lpha,  .lba,  .lbha,  .lma,
  .lya,  .lra,   .l.ra,  .lla,   .lva,
  .lsha, .l.sa,   .lsa,  .lha,   .l.la,  .lzha.$

\beginsection {\twelvemmb $zha$}

$ zhka,  zhkha,  zhga,  zhgha,  zh"na,
  zhca,  zhcha,  zhja,  zhjha,  zh~na,
  zh.ta,  zh.tha,  zh.da,  zh.dha,  zh.na,
  zhta,  zhtha,  zhda,  zhdha,  zhna,
  zhpa,  zhpha,  zhba,  zhbha,  zhma,
  zhya,  zhra,   zh.ra,  zhla,   zhva,
  zhsha, zh.sa,   zhsa,  zhha,   zh.la,  zhzha.$


\bye





